/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.InvisibleMoverBE;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InvisibleMoverBlock
extends Block
implements EntityBlock {
    private final Map<BlockPos, MoverData> dataByControl = new HashMap<BlockPos, MoverData>();
    private final Map<BlockPos, List<MoverData>> dataByMover = new HashMap<BlockPos, List<MoverData>>();

    public InvisibleMoverBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60993_().m_60913_(-1.0f, 3600000.0f).m_60955_().m_60977_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InvisibleMoverBE(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        InvisibleMoverBE invisibleMover;
        BlockState originalState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InvisibleMoverBE && (originalState = (invisibleMover = (InvisibleMoverBE)blockEntity).getOriginalState()) != null && !originalState.m_60795_()) {
            return originalState.m_60651_(level, pos, context);
        }
        return super.m_5940_(state, level, pos, context);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (random.nextFloat() < 0.1f) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public void registerData(BlockPos moverPos, BlockPos controlPos, Direction horizDirection, Direction direction) {
        MoverData data = new MoverData(moverPos, controlPos, horizDirection, direction);
        this.dataByControl.put(controlPos, data);
        this.dataByMover.computeIfAbsent(moverPos, p -> new ArrayList()).add(data);
    }

    public void removeData(BlockPos moverPos) {
        List<MoverData> set = this.dataByMover.get(moverPos);
        if (set != null) {
            for (MoverData data : set) {
                this.dataByControl.remove(data.controlPos);
            }
            this.dataByMover.put(moverPos, new ArrayList());
        }
    }

    public List<MoverData> getData(BlockPos moverPos) {
        return this.dataByMover.get(moverPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        this.activate(level, pos);
        return InteractionResult.SUCCESS;
    }

    public void m_6256_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        this.activate(level, pos);
    }

    private void activate(Level level, BlockPos pos) {
        HitResult mouseOver;
        MoverData data;
        if (level.f_46443_ && (data = this.dataByControl.get(pos)) != null && (mouseOver = SafeClientTools.getClientMouseOver()) instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)mouseOver;
            BlockEntity blockEntity = level.m_7702_(data.mover);
            if (blockEntity instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)blockEntity;
                mover.hitScreenClient(blockResult.m_82425_(), mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), blockResult.m_82434_(), data.horizDirection, data.direction);
            }
        }
    }

    public record MoverData(BlockPos mover, BlockPos controlPos, Direction horizDirection, Direction direction) {
    }
}

